### 51. Openshift

[Openshift](https://www.openshift.com/)是RedHat公共（和企业）PaaS解决方案。和Heroku相似，它也是通过运行被git提交触发的脚本来工作的，所以你可以使用任何你喜欢的方式编写Spring Boot应用启动脚本，只要Java运行时环境可用（这是在Openshift上可以要求的一个标准特性）。为了实现这样的效果，你可以使用[DIY Cartridge](https://www.openshift.com/developers/do-it-yourself)，并在`.openshift/action_scripts`下hooks你的仓库：

基本模式如下：

1.确保Java和构建工具已被远程安装，比如使用一个`pre_build` hook（默认会安装Java和Maven，不会安装Gradle）。

2.使用一个`build` hook去构建你的jar（使用Maven或Gradle），比如
```shell
#!/bin/bash
cd $OPENSHIFT_REPO_DIR
mvn package -s .openshift/settings.xml -DskipTests=true
```
3.添加一个调用`java -jar …​`的`start` hook

```shell
#!/bin/bash
cd $OPENSHIFT_REPO_DIR
nohup java -jar target/*.jar --server.port=${OPENSHIFT_DIY_PORT} --server.address=${OPENSHIFT_DIY_IP} &
```
4.使用一个`stop` hook

```shell
#!/bin/bash
source $OPENSHIFT_CARTRIDGE_SDK_BASH
PID=$(ps -ef | grep java.*\.jar | grep -v grep | awk '{ print $2 }')
if [ -z "$PID" ]
then
    client_result "Application is already stopped"
else
    kill $PID
fi
```
5.将内嵌的服务绑定到平台提供的在application.properties定义的环境变量，比如
```shell
spring.datasource.url: jdbc:mysql://${OPENSHIFT_MYSQL_DB_HOST}:${OPENSHIFT_MYSQL_DB_PORT}/${OPENSHIFT_APP_NAME}
spring.datasource.username: ${OPENSHIFT_MYSQL_DB_USERNAME}
spring.datasource.password: ${OPENSHIFT_MYSQL_DB_PASSWORD}
```
在Openshift的网站上有一篇[running Gradle in Openshift](https://www.openshift.com/blogs/run-gradle-builds-on-openshift)博客，如果想使用gradle构建运行的应用可以参考它。由于一个[Gradle bug](http://issues.gradle.org/browse/GRADLE-2871)，你不能使用高于1.6版本的Gradle。
